package pogamutmysposhbot;

import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import cz.cuni.utils.Config;
import java.io.File;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 *
 *  WARNING: you need to set the path to the planfile, edit getPlanFile() method!
 */
public class Main extends SPoshBot {
    
   
    /** Creates a new instance of agent. */
    public Main() throws ScriptedAgentException {
        super();        
    }
    
    @Override
    protected JavaBehaviour getBehaviour() {
        return new MyBehaviour("MyBehaviour", this.log, this);
    }
    
    @Override
    protected String getPlanFile() {
        return Config.getProjectsPath()+File.separator+"NoraIbrahimova-DM-SPOSH"+File.separator+"src"+File.separator+"pogamutmysposhbot"+File.separator+"sposhPlan.lap";
    }
    
    @Override
    protected void prePrepareAgent()  throws PogamutException {        
        super.prePrepareAgent();
        /* Prepares agent logic to run - like initializing neural networks etc.
        not for establishing communication! */
    }
    
    @Override
    protected void postPrepareAgent() throws PogamutException {                
        super.postPrepareAgent();
        this.getBody().initializer.setBotSkillLevel(3);
        /* Prepare logic according to information from gathered from startCommunication
        like choosing plan/parameters according to game type. */
        /**
	 * Prepares list of agent will run around.
	 * He will run only around weapons and armors so he will be armored and armed soon
	 */       
    }
    
    private boolean first = true;
    
    protected void doLogic() {
        if (first) { // workaround :-(
            this.getBody().configureAutoTrace(false);
            first = false;
        }
        super.doLogic();
    }
    
    protected void shutdownAgent() throws PogamutException {        
        super.shutdownAgent();
        /* Clean up after the end of simulation of agent */
    }
    
    public static void main(String[] args) {
    }
}
